/*-----------------------------------------------------------------------------------

 Template Name:Chitchat
 Template URI: themes.pixelstrap.com/chitchat
 Description: This is Chat website
 Author: Pixelstrap
 Author URI: https://themeforest.net/user/pixelstrap

 ----------------------------------------------------------------------------------- */
// 01. Tooltip js
// 02. Background Image js
// 03. OwlCarousel js
// 04. Chitchat Loader js
// 05. Search js
// 06. Mute js
// 07. Button Effect js
// 08. Collapse Title js
// 09. Refresh Request information next & previous button
// 10 .Full Screen
// 11. Header fix
// 12. Tap on Top
// 13. Customizer
// 14  Footer responsive js
// 15  Pin box
// 16  Reminder
// 17  Set wallpaper onclick
// 18  Custom tab
// 19  Theme mode
// 20. Add claas to nav
// 21. Live chat
// 22. Toggle classes
// 23. ADD tO-DO LIST
// 24. Right sidebar
// 25. Sticker
// 26. Emoji
// 27. Profile open
// 28. Dropdown
(function($) {
	"use strict";

	/*=====================
	  01. Tooltip js
	  ==========================*/
	tippy('.sidebar-main .icon-btn', {
		theme: 'tooltiprad',
		placement: 'right-end',
		arrow: false
	});
	tippy('.user-popup', {
		content: "Status",
		theme: 'gradienttooltip',
		placement: 'right-end',
		arrow: false
	});
	tippy('.calls  > li > .icon-btn', {
		placement: 'bottom-end',
		arrow: true
	});
	tippy('.clfooter a', {
		placement: 'top-end',
		arrow: true
	});
	tippy('.audiocall2 a', {
		placement: 'top-end',
		arrow: true
	});
	tippy('.videocall a', {
		placement: 'top-end',
		arrow: true
	});

	/*=====================
	  02. Background Image js
	  ==========================*/
	$(".bg-top").parent().addClass('b-top');
	$(".bg-bottom").parent().addClass('b-bottom');
	$(".bg-center").parent().addClass('b-center');
	$(".bg_size_content").parent().addClass('b_size_content');
	$(".bg-img").parent().addClass('bg-size');
	$('.bg-img').each(function() {
		var el = $(this),
			src = el.attr('src'),
			parent = el.parent();
		parent.css({
			'background-image': 'url(' + src + ')',
			'background-size': 'cover',
			'background-position': 'center',
			'display': 'block'
		});
		el.hide();
	});

	/*=====================
	  03. OwlCarousel js
	  ==========================*/
	var owl_carousel_custom_recent = {
		init: function() {
			var recent = $('.recent-slider');
			recent.owlCarousel({
				items: 3,
				dots: false,
				loop: true,
				margin: 15,
				nav: false,
				autoplay: true,
				autoplayTimeout: 2000,
				autoplayHoverPause: true,
				responsive: {
					768: {
						items: 7
					},
					800: {
						items: 7
					},
					801: {
						items: 2
					},
					1366: {
						items: 2
					},
					1600: {
						items: 3
					}
				}
			})
		}
	};
	owl_carousel_custom_recent.init();

	var owl_carousel_custom_testimonial = {
		init: function() {
			var recent = $('.testimonial-slider');
			recent.owlCarousel({
				items: 4,
				dots: false,
				loop: true,
				margin: 60,
				nav: false,
				autoplay: true,
				autoplayTimeout: 5000,
				autoplayHoverPause: false,
				responsive: {
					320: {
						items: 1,
						margin: 25,
					},
					575: {
						items: 2,
						margin: 25,
					},
					1070: {
						items: 3,
						margin: 25,
					},
					1600: {
						items: 4
					},
				}
			})
		}
	};
	owl_carousel_custom_testimonial.init();

	var owl_carousel_custom_price = {
		init: function() {
			var recent = $('.price-slider');
			recent.owlCarousel({
				items: 3,
				dots: false,
				loop: true,
				margin: 60,
				nav: false,
				autoplay: true,
				autoplayTimeout: 5000,
				autoplayHoverPause: false,
				responsive: {
					320: {
						items: 1,
						margin: 25,
					},

					601: {
						items: 2,
						margin: 25,
					},
					1070: {
						items: 3,
						margin: 25,
					},
					1600: {
						items: 3
					},
				}
			})
		}
	};
	owl_carousel_custom_price.init();

	var owl_carousel_custom_team = {
		init: function() {
			var recent = $('.team-slider');
			recent.owlCarousel({
				items: 2,
				dots: false,
				loop: true,
				margin: 20,
				nav: false,
				autoplay: true,
				autoplayTimeout: 5000,
				autoplayHoverPause: false,
				responsive: {
					320: {
						items: 1
					},
					1199: {
						items: 2
					},
				}
			})
		}
	};
	owl_carousel_custom_team.init();

	var owl_carousel_custom_testimonial = {
		init: function() {
			var recent = $('.counter-slider');
			recent.owlCarousel({
				items: 4,
				dots: false,
				loop: true,
				margin: 60,
				nav: false,
				autoplay: true,
				autoplayTimeout: 5000,
				autoplayHoverPause: false,
				responsive: {
					320: {
						items: 1,
						margin: 25,
					},
					480: {
						items: 2,
						margin: 25,
					},
					575: {
						items: 3,
						margin: 25,
					},
					768: {
						items: 4,
						margin: 25,
					},
					1600: {
						items: 4
					},
				}
			})
		}
	};
	owl_carousel_custom_testimonial.init();

	/*=====================
	     04. Chitchat Loder js
	     ==========================*/
	$('.chitchat-loader').slideUp('slow', function() {
		$(this).remove();
	});

	/*=====================
	     05. Search js
	     ==========================*/
	$('.search').on('click', function(e) {
		$(this).siblings().toggleClass("open");
	});
	$('.close-search').on('click', function(e) {
		$(this).parent().parent().removeClass("open");
	});
	$('.search-right').on('click', function(e) {
		$(this).parent().parent().parent().parent().parent().parent().find(".form-inline").toggleClass("open");
	});
	$('.close-search').on('click', function(e) {
		$(this).parent().parent().removeClass("open");
	});

	/*=====================
	     06. Mute js
	     ==========================*/
	$('.mute').on('click', function(e) {
		$(this).children().toggleClass("off");
	});

	/*=====================
	     07. Button Effect js
	     ==========================*/
	$('.button-effect').on('click', function(e) {
		e.preventDefault();
		var self = $(this),
			wave = '.effect-wave',
			btnWidth = self.outerWidth(),
			x = e.offsetX,
			y = e.offsetY;
		self.prepend('<span class="effect-wave"></span>')
		$(wave)
			.css({
				'top': y,
				'left': x
			})
			.animate({
				opacity: '0',
				width: btnWidth * 2,
				height: btnWidth * 2
			}, 500, function() {
				self.find(wave).remove()
			})
	})

	/*=====================
	     08. Collapse Title js
	     ==========================*/
	$('.block-title').on('click', function(e) {
		e.preventDefault;
		var speed = 300;
		var thisItem = $(this).parent(),
			nextLevel = $(this).next('.block-content');
		if (thisItem.hasClass('open')) {
			thisItem.removeClass('open');
			nextLevel.slideUp(speed);
		} else {
			thisItem.addClass('open');
			nextLevel.slideDown(speed);
		}
	});

	/*=====================
	     09. Refresh Request information next & previous button
	     ==========================*/
	$('.refresh').on('click', function(e) {
		$(this).toggleClass('refreshed');
	});
	$('.req-info').on('click', function(e) {
		$(this).addClass('disabled');
	});
	$('.next').on('click', function(e) {
		$(this).parent().parent().siblings().addClass('open');
	});
	$('.previous').on('click', function(e) {
		$(this).parent().parent().parent().removeClass('open');
	});

	$('.chat-cont-toggle').on('click', function(e) {
		$('.chat-cont-setting ').toggleClass('open');
	});




	/*=====================
	      10 .Full Screen
	      ==========================*/

	$('.toggle-full-screen').on('click', function(e) {
		$('#videocall').toggleClass("active");
	})

	/*=====================
	      11.Header fix
	      ==========================*/
	$(window).scroll(function() {
		var scroll = $(window).scrollTop();
		if (scroll >= 60) {
			$(".landing-header").addClass("fixed");
		} else {
			$(".landing-header").removeClass("fixed");
		}
	});
	/*=====================
	  12.Tap on Top
	  ==========================*/
	$(window).on('scroll', function() {
		if ($(this).scrollTop() > 600) {
			$('.tap-top').fadeIn();
		} else {
			$('.tap-top').fadeOut();
		}
	});
	$('.tap-top').on('click', function() {
		$("html, body").animate({
			scrollTop: 0
		}, 600);
		return false;
	});

	/*=====================
	       13. Customizer
	       ==========================*/
	// $('<div class="sidebar-pannle-main"><ul><li class="rtl-setting icon-btn btn-primary">RTL</li><li class="cog-click icon-btn btn-success" ><i class="fa fa-cog"></i></li></ul></div> <section class="setting-sidebar"><div class="theme-title"><div class="media"><div><h2>Customizer</h2><h4>Real Time Customize</h4></div><div class="media-body"><a class="icon-btn btn-outline-light button-effect pull-right cog-close" href="#"><i class="fa fa-close"></i></a></div></div></div><div class="color-picker"><h5>Choose color</h5><ul class="colors"><li class="color active" data-attr="style"></li><li class="color1" data-attr="style1"></li><li class="color2" data-attr="style2"></li><li class="color3" data-attr="style3"></li><li class="color4" data-attr="style4"></li><li class="color5" data-attr="style5"></li><li class="color6" data-attr="style6"></li></ul></div><div class="theme-layout"><h5>Layout</h5><ul><li class="active" data-attr=""><div class="sidebar"></div><div class="sidebar-content"></div></li><li data-attr="dark-sidebar"><div class="sidebar"></div><div class="sidebar-content"></div></li><li data-attr="dark"><div class="sidebar"></div><div class="sidebar-content"></div></li><li data-attr="colorfull"><div class="sidebar"></div><div class="sidebar-content"></div></li></ul></div><div class="chat-wallpaper"><h5>Chat wallpaper</h5><ul class="wallpaper"><li class="bg-color bg-default active"></li><li class="bg-size" style="background-image: url("../assets/images/wallpaper/2.jpg"); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/wallpaper/2.jpg" alt="Avatar" style="display: none;"></li><li class="bg-size" style="background-image: url("../assets/images/wallpaper/3.jpg"); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/wallpaper/3.jpg" alt="Avatar" style="display: none;"></li><li class="bg-size" style="background-image: url("../assets/images/wallpaper/4.jpg"); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/wallpaper/4.jpg" alt="Avatar" style="display: none;"></li><li class="bg-size" style="background-image: url("../assets/images/wallpaper/5.jpg"); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/wallpaper/5.jpg" alt="Avatar" style="display: none;"></li><li class="bg-size" style="background-image: url("../assets/images/wallpaper/1.jpg"); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/wallpaper/1.jpg" alt="Avatar" style="display: none;"></li> <br><li class="bg-color grediant-1"></li><li class="bg-color grediant-2"></li><li class="bg-color grediant-3"></li><li class="bg-color grediant-4"></li><li class="bg-color grediant-5"></li><li class="bg-color grediant-6"></li></ul></div><div class="sidebar-setting"><h5>Sidebar</h5><ul><li class="active three-column"><div class="sm-sidebar"></div><div class="sidebar"></div><div class="sidebar-content"></div></li><li class="two-column"><div class="sidebar"></div><div class="sidebar-content"></div></li></ul></div> </section>').appendTo($('body'));
	$('.cog-click').on('click', function() {
		$('.setting-sidebar').css("right", "0px");
	});
	$(".cog-close").on('click', function() {
		$('.setting-sidebar').css("right", "-400px");
	});
	$(".theme-layout li").on('click', function() {
		$(".theme-layout li").removeClass('active');
		$(this).addClass("active");
		var themeLayout = $(this).attr("data-attr");
		$("body").attr("class", themeLayout);
	});
	var body_event = $("body");
	body_event.on("click", ".rtl-setting", function() {
		$(this).toggleClass('rtl');
		$('body').removeClass('rtl');
		if ($('.rtl-setting').hasClass('rtl')) {
			$('.rtl-setting').text('LTR');
			$('body').addClass('rtl');
		} else {
			$('.rtl-setting').text('RTL');
		}
		return false;
	});
	body_event.on("click", ".themes-content li", function() {
		$(this).addClass('active').siblings().removeClass('active');
		$color = $(this).attr("data-attr");
		$("#color").attr("href", "../assets/css/" + $color + ".css");
		return false;
	});

	/*=====================
	14 footer responsive js
	==========================*/
	var contentwidth = jQuery(window).width();
	if ((contentwidth) < '768') {
		jQuery('.footer-title h3').append('<span class="according-menu"></span>');
		jQuery('.footer-title').on('click', function() {
			jQuery('.footer-title').removeClass('active');
			jQuery('.footer-contant').slideUp('normal');
			if (jQuery(this).next().is(':hidden') == true) {
				jQuery(this).addClass('active');
				jQuery(this).next().slideDown('normal');
			}
		});
		jQuery('.footer-contant').hide();
	} else {
		jQuery('.footer-contant').show();
	}
	/*=====================
	    15. Pin box
	    ==========================*/
	$('.ti-pin2').on('click', function() {
		$(this).parent().parent().parent().toggleClass('pined');
	});

	/*=====================
	    16 Reminder
	    ==========================*/
	$(".reminder-count li").on('click', function() {
		$('.reminder-count li').removeClass('active');
		$(this).addClass('active');
	});

	$('.Show-reminder').on('click', function(e) {
		$('.target-reminder-list').show(500);
		$('.Show-reminder').hide(0);
		$('.Hide-reminder').show(0);
	});
	$('.Hide-reminder').on('click', function(e) {
		$('.target-reminder-list').hide(500);
		$('.Show-reminder').show(0);
		$('.Hide-reminder').hide(0);
	});
	$('.toggle').on('click', function(e) {
		$('.target-reminder-list').toggle('slow');
	});

	/*=====================
	    17 set wallpaper onclick
	    ==========================*/
	$('.wallpaper li.bg-color').on('click', function() {
		var color = $(this).css('background-image');
		$(".wallpaper li").removeClass('active');
		$(this).addClass("active");
		$(".chitchat-main .messages").css({
			'background-image': color,
			'background-blend-mode': 'unset',
		});
	});
	$('.wallpaper li.bg-size').on('click', function() {
		var color = $(this).children(".bg-img").attr('src');
		$(".wallpaper li").removeClass('active');
		$(this).addClass("active");
		$(".chitchat-main .messages").css({
			'background-image': 'url(' + color + ')',
			'background-color': 'transparent'
		});
	});

	/*=====================
	    18 custom tab
	    ==========================*/
	$(".contact-log-main li , .call-log-main li").on('click', function() {
		$(this).parent().find("li").removeClass("active");
		$(this).addClass("active");
	});
	$("#myTab1 li a").on('click', function() {
		var active_class = $(this).attr("data-to");
		$('.messages.custom-scroll').removeClass("active");
		$('#' + active_class).addClass("active");
	});
	$(".chat-tabs .nav-tabs li[data-to]").on('click', function() {
		$('.chitchat-main .tabto').removeClass("active");
		var active_class = $(this).attr("data-to");
		$('.' + active_class).addClass("active");
	});
	$(".sidebar-top  a").on('click', function() {
		$(".sidebar-top  a").removeClass("active");
		$(this).addClass("active");
		$('.dynemic-sidebar').removeClass("active");
		var active_class = $(this).attr("href");
		$('#' + active_class).addClass("active");
	});


	/*=====================
	  22. toggle classes
	  ==========================*/
	$('.mobile-sidebar').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
	});
	$('.chat-main .chat-box').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
	});
	$('.group-main .group-box').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
	});
	$('.call-log-main .call-box').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
	});
	$('.contact-log-main .contact-box').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
	});

	$('.mobile-back').on('click', function() {
		$('.chitchat-container').toggleClass("mobile-menu");
		$('.main-nav').removeClass("on");
	});

$("#audio_config").val('1');
	$('.chat-friend-toggle').on('click', function() {
		$('.chat-frind-content').toggle();
	});

	$('.gr-chat-friend-toggle').on('click', function() {
		$('.gr-chat-frind-content').toggle();
	});
	$('.msg-setting').on('click', function() {
		$(this).siblings('.msg-dropdown').toggle();
	});
	$(".favourite").on('click', function() {
		$(this).toggleClass("btn-outline-primary").toggleClass("btn-primary");
	});
	$(".edit-btn").on('click', function() {
		$(this).parent().parent().toggleClass("open");
	});
	function linkify(inputText) {
    var replacedText, replacePattern1, replacePattern2, replacePattern3;

    //URLs starting with http://, https://, or ftp://
    replacePattern1 = /(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;]*[-A-Z0-9+&@#\/%=~_|])/gim;
    replacedText = inputText.replace(replacePattern1, '<a href="$1" target="_blank" style="color: cyan;">$1</a>');

    //URLs starting with "www." (without // before it, or it'd re-link the ones done above).
    replacePattern2 = /(^|[^\/])(www\.[\S]+(\b|$))/gim;
    replacedText = replacedText.replace(replacePattern2, '$1<a href="http://$2" target="_blank" style="color: cyan;">$2</a>');

    //Change email addresses to mailto:: links.
    replacePattern3 = /(([a-zA-Z0-9\-\_\.])+@[a-zA-Z\_]+?(\.[a-zA-Z]{2,6})+)/gim;
    replacedText = replacedText.replace(replacePattern3, '<a href="mailto:$1" style="color: cyan;">$1</a>');

    return replacedText;
}
					const number_sum_user = [];
$("input[name='amount[]']").each(function (i,v) {
    number_sum_user.push(this.value);
});
function findThreeLargestNumbers(array) {
  return [...array].sort((a, b) => b - a).slice(0, 3);
}
var sum_number_we = findThreeLargestNumbers(number_sum_user);
$("."+sum_number_we[0]).css("background", "linear-gradient(-45deg, #F5CD00, #E1b900, #D7a100)");
$("."+sum_number_we[1]).css("background", "linear-gradient(-45deg, #808080, #A9A9A9, #D3D3D3)");
$("."+sum_number_we[2]).css("background", "linear-gradient(-45deg, #CD7F32, #BE7023, #AF6114, #DC8E41)");
window.addEventListener('online', () => $("#nointernetmodal").css("display", "none"));
window.addEventListener('online', () => $(".sidebar-toggle").css("filter", "blur(0px)"));
window.addEventListener('offline', () => $("#nointernetmodal").css("display", "block"));
window.addEventListener('offline', () => $(".sidebar-toggle").css("filter", "blur(8px)"));
	document.getElementById("name_user_txt").textContent = $('#name_user_current').val();
	document.getElementById("email_user_txt").textContent = $('#email_user_current').val();
	$("#SaveName").click(function() {
		var usernames = $('#username_JS').val();
		document.getElementById("name_user_txt").textContent = $('#name_user_current').val();
		document.getElementById("email_user_txt").textContent = $('#email_user_current').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSave.php", {
				username: usernames,
				name: $('#name_user_current').val(),
				email: $('#email_user_current').val(),
			},
			function(data, status) {
				document.getElementById("name_JS").value = $('#name_user_current').val();
			}
		);
	});
	$("#SavePassword").click(function() {
		var usernames = $('#username_JS').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatPassword.php", {
				username: usernames,
				password: $('#password_new').val(),
			},
			function(data, status) {
				window.location.replace("https://app2.drsiamakheydari.ir/ChatLogout.php");
			}
		);
	});
	$("#SaveProfile").click(function() {
		var usernames = $('#username_JS').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatProfile.php", {
				username: usernames,
				profile: document.querySelector('input[name="profile_pic"]:checked').value,
			},
			function(data, status) {
				if (location.pathname == "/ChatMessage") {
					location.reload();
				}
			}
		);
	});
	$("#SendSMSa").click(function() {
		var Pnumber = $('#phone_number_a').val();
		var Tmsg = $('#text_a').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSms.php", {
				number_1: Pnumber,
				txt_1: Tmsg,
				level: '1',
			},
			function(data, status) {
				//if(digits_only(data) === true){
				alert('پیامک با موفقیت ارسال شد.');
				// } else {
				//  alert(data);
				//}
			}
		);
	});
	$("#SendSMSb").click(function() {
		var Pnumber = $('#phone_number_b').val();
		var Tmsg = $('#text_b').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSms.php", {
				number_2: Pnumber,
				txt_2: Tmsg,
				level: '2',
			},
			function(data, status) {
				//if(digits_only(data) === true){
				alert('پیامک با موفقیت ارسال شد.');
				// } else {
				//alert(data);
				//}
			}
		);
	});
	$("#SendSMSc").click(function() {
		var Pnumber = $('#phone_number_c').val();
		var Tmsg = $('#text_c').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSms.php", {
				number_3: Pnumber,
				txt_3: Tmsg,
				level: '3',
			},
			function(data, status) {
				//if(digits_only(data) === true){
				alert('پیامک با موفقیت ارسال شد.');
				// } else {
				//  alert(data);
				//}
			}
		);
	});
	$("#SaveFileB").click(function() {
		var Pnumber = $('#phone_number_b').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSaveFile.php", {
				number: Pnumber,
				file: '1',
			},
			function(data, status) {
				//if(digits_only(data) === true){
				alert('شماره ها با موفقیت در حافظه ذخیره شدند.');
				// } else {
				//alert(data);
				//}
			}
		);
	});
	$("#SaveFileC").click(function() {
		var Pnumber = $('#phone_number_c').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatSaveFile.php", {
				number: Pnumber,
				file: '2',
			},
			function(data, status) {
				//if(digits_only(data) === true){
				alert('شماره ها با موفقیت در حافظه ذخیره شدند.');
				// } else {
				//  alert(data);
				//}
			}
		);
	});

	function yourFunction() {
		var response = '';
		var group_s = $('#group_JS').val();
		var audio = new Audio('https://app2.drsiamakheydari.ir/iPhone%20sending%20and%20receive%20text%20message%20iOS%2010%20(A2E48DB-MSB).mp3');
		$.ajax({
			type: "POST",
			url: "https://app2.drsiamakheydari.ir/ChatUpdate.php",
			data: {
				group: group_s
			},
			dataType: "json",
			success: function(text) {
				var res = text;
				jQuery.each(res, function(index, item) {
					if (!$('#' + item).length) // use this if you are using id to check
					{
						$.post(
							"https://app2.drsiamakheydari.ir/ChatGetMessage.php", {
								id: item,
								group: group_s,
							},
							function(data, status) {
								var json = $.parseJSON(data);
								if (json.tick == '0') {
									var tick_status = '';
									var tick_style = '';
								}
								if (json.tick == '1') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = '';
								}
								if (json.tick == '2') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;"><img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/programmer.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = '';
								}
								if (json.tick == '11') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_1.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = 'background: linear-gradient(-45deg, #F5CD00, #E1b900, #D7a100);background-size: 400% 400%;animation: gradient 15s ease infinite;';
								}
								if (json.tick == '12') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_2.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = 'background: linear-gradient(-45deg, #808080, #A9A9A9, #D3D3D3);background-size: 400% 400%;animation: gradient 15s ease infinite;';
								}
								if (json.tick == '13') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_3.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = 'background: linear-gradient(-45deg, #CD7F32, #BE7023, #AF6114, #DC8E41);background-size: 400% 400%;animation: gradient 15s ease infinite;';
								}
								if (json.tick == '14') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/warning.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = 'background: linear-gradient(-45deg, #ffa6a6, #9b0303, #e14d4d);background-size: 400% 400%;animation: gradient 15s ease infinite;';
								}
								if (json.tick == '15') {
									var tick_status = '';
									var tick_style = '';
								}
								$('<li class="replies last typing-m" id="' + item + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + json.profile + '&quot;); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="' + json.profile + '" alt="Avatar" style="display: none;"></div><div class="media-body"> <div class="contact-name"> <h5>' + json.name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.time + '</h6> <ul class="msg-box"> <li> <h5 style="border-radius: 0 50px 50px 50px;"> <div class="type"> <div class="typing-loader"></div></div></h5> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
								setTimeout(function() {
									$('.typing-m').hide();
									if (json.username == '0') {
										$('<li class="replies" id="' + item + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + json.profile + '&quot;); background-size: cover; background-position: center center; display: block;"></div><div class="media-body"> <div class="contact-name"> <h5>' + json.name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.time + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;border-radius: 0 50px 50px 50px;text-align: right;' + tick_style + '" ondblclick="copy(this)">' + linkify(json.message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" onClick="replyMsgNow(\'' + item + '\')" id="RPMG"><i class="fa fa-share"></i></div><div class="msg-setting" onClick="CreplyMsgNow(\'' + item + '\')" id="CRPMG" style="display: none"><i class="fa fa-times"></i></div></li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
										if($("#audio_config").val() == 1){
										audio.play();
										}
										if (json.message !== 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید') {
											setTimeout(function() {
												if (location.pathname == "/ChatMessage") {
													window.location.reload();
												}
											}, 2000);
										}
									} else {
										if (json.replay == '0') {
											if (json.type == '0') {
												$('<li class="replies" id="' + item + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + json.profile + '&quot;); background-size: cover; background-position: center center; display: block;"></div><div class="media-body"> <div class="contact-name"> <h5>' + json.name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.time + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;border-radius: 0 50px 50px 50px;text-align: right;' + tick_style + '" ondblclick="copy(this)">' + linkify(json.message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" onClick="replyMsgNow(\'' + item + '\')" id="RPMG"><i class="fa fa-share"></i></div><div class="msg-setting" onClick="CreplyMsgNow(\'' + item + '\')" id="CRPMG" style="display: none"><i class="fa fa-times"></i></div></li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
											if($("#audio_config").val() == 1){
												audio.play();
											}
											} else {
												if (json.type == 'picture' || json.type == 'png' || json.type == 'jpg' || json.type == 'jpeg' || json.type == 'gif' || json.type == 'svg') {
													var type_element = `
                    <ul class="auto-gallery" style="width: 100%;border-radius: 0 50px 50px 50px;">
                                    <li class="bg-size" style="background-image: url(&quot;` + json.link + `&quot;); background-size: cover; background-position: center center; display: block;width: 100%;height: 215px;"><img class="bg-img" src="` + json.link + `" alt="Avatar" style="display: none;"></li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(json.message) + `</h5>
</ul>
                    `;
												}
												if (json.type == 'video' || json.type == 'mkv' || json.type == 'mp4' || json.type == 'vlc') {

													var type_element = ` <ul class="auto-gallery" style="width: 100%;border-radius: 0 50px 50px 50px;">
                                    <li class="bg-size" style="height: 100%;width: 100%;">
                                        <video width="100%" style="border-radius: 20px;" controls>
  <source src="` + json.link + `" type="video/` + json.type + `">
  مرورگر شما پشتیبانی نمی کند.
</video>
                                    </li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(json.message) + `</h5>
</ul>

                             `;
												}
												if (json.type == 'audio' || json.type == 'mp3' || json.type == 'wav') {

													var type_element = ` <ul class="auto-gallery" style="width: 100%;border-radius: 0 50px 50px 50px;">
                                    <li class="bg-size" style="height: 100%;width: 100%;">
<audio style="width: 100%"; controls>
  <source src="` + json.link + `" type="audio/` + json.type + `">
مرورگر شما پشتیبانی نمی کند.
</audio>
                                    </li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(json.message) + `</h5>
</ul>

                             `;
												}
												if (json.type == 'document' || json.type == 'zip' || json.type == 'rar' || json.type == 'xls' || json.type == 'xlsx' || json.type == 'pdf' || json.type == 'docx' ||
													json.type == 'pptx' || json.type == 'ppt' || json.type == 'pptm') {

													var type_element = ` 
                                 <div class="document" style="border-radius: 0 50px 50px 50px;">
      <i class="` + json.icon + ` font-primary"></i>
   <div class="details">
             <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + json.name + `</h5>
      <h6 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + json.size + `</h6>
      <h5 ondblclick="copy(this)" style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + linkify(json.message) + `</h5>
   </div>
   <div class="icon-btns">
      <a class="icon-btn btn-outline-light" href="` + json.link + `" target="_blank">
         <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-download">
            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
            <polyline points="7 10 12 15 17 10"></polyline>
            <line x1="12" y1="15" x2="12" y2="3"></line>
         </svg>
      </a>
   </div>
</div>

                             `;
												}
												$('<li class="replies" id="' + item + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + json.profile + '&quot;); background-size: cover; background-position: center center; display: block;"></div><div class="media-body"> <div class="contact-name"> <h5>' + json.name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.time + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> ' + type_element + '<div class="msg-dropdown-main"><div class="msg-setting" onClick="replyMsgNow(\'' + item + '\')" id="RPMG"><i class="fa fa-share"></i></div><div class="msg-setting" onClick="CreplyMsgNow(\'' + item + '\')" id="CRPMG" style="display: none"><i class="fa fa-times"></i></div></li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
											if($("#audio_config").val() == 1){
											    	audio.play();
											}
											}
										} else {
											$.post(
												"https://app2.drsiamakheydari.ir/ChatGetReplay.php", {
													number: group_s,
													replay: json.replay,
												},
												function(data, status) {
													$('<li class="replies" id="' + item + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + json.profile + '&quot;); background-size: cover; background-position: center center; display: block;"></div><div class="media-body"> <div class="contact-name"> <h5>' + json.name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.time + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;border-radius: 0 50px 50px 50px;text-align: right;' + tick_style + '" ondblclick="copy(this)">ریپلای به' + data + '<hr>' + linkify(json.message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" onClick="replyMsgNow(\'' + item + '\')" id="RPMGS"><i class="fa fa-share"></i></div><div class="msg-setting" onClick="CreplyMsgNow(\'' + item + '\')" id="CRPMGS" style="display: none"><i class="fa fa-times"></i></div></div></li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
	if($("#audio_config").val() == 1){
	audio.play();
	}
												}
											);
										}
									}
								}, 2000);
								if (location.pathname == "/ChatMessage") {
									const LastMsgReply = document.getElementById(item);
									LastMsgReply.scrollIntoView();
								}
							}
						);
					}
				});
			}
		});
		setTimeout(yourFunction, 1000);
	}
	if (location.pathname == "/ChatMessage") {
		yourFunction();
	}

	function yourFunctionRemove() {
		var response = '';
		var group_s = $('#group_JS').val();
		$.ajax({
			type: "POST",
			url: "https://app2.drsiamakheydari.ir/ChatRemoveUpdate.php",
			data: {
				group: group_s,
				username: $('#username_JS').val()
			},
			dataType: "json",
			success: function(text) {
				var res = text;
				jQuery.each(res, function(index, item) {
					$("#" + item).remove();
				});
			}
		});
		setTimeout(yourFunctionRemove, 1000);
	}
	if (location.pathname == "/ChatMessage") {
		yourFunctionRemove();
	}
	$(".remove-msg").click(function() {
		var ids = $(this).attr("data-id");
		var group_s = $('#group_JS').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatRemove.php", {
				id: ids,
				group: group_s,
			},
			function(data, status) {
				$("#" + ids).remove();
			}
		);
	});
	$(".remove-azmon").click(function() {
		var uniqids = $(this).attr("data-uid");
		$.post(
			"https://app2.drsiamakheydari.ir/ChatRemoveExam.php", {
				uniqid: $(this).attr("data-id"),
			},
			function(data, status) {
				$("#" + uniqids).remove();
			}
		);
	});
	$(".create-exam-btn").click(function() {
		var nameExam = $('#nameExam').val();
		var uidExam = $('#uidExam').val();
		var timerExam = $('#timerExam').val();
		var bodyExam = $('#bodyExam').val();
		$.post(
			"https://app2.drsiamakheydari.ir/ChatCreateExam.php", {
				name: nameExam,
				uniqid: uidExam,
				timer: timerExam,
				body: bodyExam,
			},
			function(data, status) {
					$(`<li>
            <div class="chat-box" id="`+uidExam+`">
                <div class="media">
                    <div class="profile offline bg-size" style="background-image: url('https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo.png'); background-size: cover; background-position: center center; display: block;">
                        <img class="bg-img" src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo.png" alt="Avatar" style="display: none;">
                    </div>
                    <div class="details">
                        <h5>`+nameExam+`</h5>
                        <h6>زمان آزمون: `+timerExam+`</h6>
                    </div>
                    <div class="media-body">
                        <a class="icon-btn btn-outline-primary btn-sm pull-right link" href="https://app2.drsiamakheydari.ir/ChatExam.php?id=`+uidExam+`">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-link-45deg" viewBox="0 0 16 16">
  <path d="M4.715 6.542 3.343 7.914a3 3 0 1 0 4.243 4.243l1.828-1.829A3 3 0 0 0 8.586 5.5L8 6.086a1.002 1.002 0 0 0-.154.199 2 2 0 0 1 .861 3.337L6.88 11.45a2 2 0 1 1-2.83-2.83l.793-.792a4.018 4.018 0 0 1-.128-1.287z"></path>
  <path d="M6.586 4.672A3 3 0 0 0 7.414 9.5l.775-.776a2 2 0 0 1-.896-3.346L9.12 3.55a2 2 0 1 1 2.83 2.83l-.793.792c.112.42.155.855.128 1.287l1.372-1.372a3 3 0 1 0-4.243-4.243L6.586 4.672z"></path>
</svg>
                        </a>
                        <a class="icon-btn btn-outline-primary btn-sm pull-right remove-azmon" data-uid="`+uidExam+`">
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
  <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z"></path>
  <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z"></path>
</svg>
                        </a>
                    </div>
                </div>
            </div>
        </li>`).appendTo($('.chat-main'));
        $('#nameExam').val(null);
		$('#uidExam').val(null);
		$('#timerExam').val(null);
		$('#bodyExam').val(null);
		document.getElementById('CloseExamNew').click()
			}
		);
	});
	$(".reply-msg").click(function() {
		var ids = $(this).attr("data-id");
		$('#replay_config').val(ids);
		$(".reply-msg").css("display", "none");
		$(".reply-cancle").css("display", "");
		alert("متن ریپلای شد. لطفا پیام خود را بنویسید.");
	});
	$(".reply-cancle").click(function() {
		var ids = $(this).attr("data-id");
		$('#replay_config').val(null);
		$(".reply-msg").css("display", "");
		$(".reply-cancle").css("display", "none");
		alert("آخرین متن ریپلای شده از ریپلای خارج شد.");
	});
	//setTimeout(function() {
	$.post(
		"https://app2.drsiamakheydari.ir/ChatScroll.php", {
			group: $('#group_JS').val(),
		},
		function(data, status) {
			if (location.pathname == "/ChatMessage") {
				const LastMsg = document.getElementById(data);
				LastMsg.scrollIntoView();
			}
		}
	);
	//}, 1000);
	if($('#first_JS').val() == 0){
	$(`<li class="replies"><div class="media">
                    <div class="profile mr-4 bg-size" style="background-image: url('https://images.squarespace-cdn.com/content/v1/5b9d4d4a5cfd7967a7b39d4f/1561271571835-QDYZT5E5LTAW29IXNJ3T/chatbot+avatar+Cute_V1.png?format=1500w'); background-size: cover; background-position: center center; display: block;">
                      <img class="bg-img" src="https://images.squarespace-cdn.com/content/v1/5b9d4d4a5cfd7967a7b39d4f/1561271571835-QDYZT5E5LTAW29IXNJ3T/chatbot+avatar+Cute_V1.png?format=1500w" alt="Avatar" style="display: none;">
                    </div>
                    <div class="media-body">
                      <div class="contact-name">
                        <h5 style="padding-left: 3px;">ربات گروه</h5>
                                                                        <img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">
                        <img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/programmer.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">
                                                                                                                        
                        <ul class="msg-box">
                          <li class="msg-setting-main" style="width: 100%;height: 100%;">
                                                                <ul class="auto-gallery" style="width: 100%;border-radius: 0 50px 50px 50px;">
                                      <a href="https://app2.drsiamakheydari.ir/upload/B47BA0F4-2D75-4C68-A37D-B3FE9DF9227C.jpeg" data-fancybox="gallery" data-caption="">
	                                    <li class="bg-size" style="background-image: url(&quot;https://app2.drsiamakheydari.ir/upload/B47BA0F4-2D75-4C68-A37D-B3FE9DF9227C.jpeg&quot;); background-position: center center; display: block; width: 100%; height: 215px; background-size: cover;"><img class="bg-img" src="https://app2.drsiamakheydari.ir/upload/B47BA0F4-2D75-4C68-A37D-B3FE9DF9227C.jpeg" alt="Avatar" style="display: none;"></li>
</a>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">با سلام خدمت تمام دانش آموزان و اولیا محترم از آنجایی که گروه مشاوره ای دکتر سیامک حیدری هرساله  با بروزترین متد های برنامه ریزی استانداردهای کشوری با شما همراه بوده؛ با توجه به اختلال در اینترنت تیم مشاوره بعد از جلسات متعهدانه و هم فکری بر آن شد که برای اولین بار در کشور پلفترمی طراحی شود که گزارش های داوطلبان ثبت گردد. برای شما که لایق بهترین هایید.قبل از استفاده از پلتفرم حتما قوانین استفاده از پلتفرم را باید به صورت دقیق مطالعه بفرمایید و فعالیت شما در این گروه به منزله موافقت با این قوانین است.</h5>
</ul>

                                                                                                                                                
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div></li>`).appendTo($('.messages .chatappend'));
                  $.post(
		"https://app2.drsiamakheydari.ir/ChatUpdateFirst.php", {
			username: $('#username_JS').val(),
		},
		function(data, status) {
			
		}
	);
	}
	if (!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
		$(".chitchat-left-sidebar").css("display", "");
	}
	if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
		$("#backSetting").css("display", "");
		$("#backSetting").click(function() {
			location.replace("https://app2.drsiamakheydari.ir/ChatSetting");
		});
		$("#backChat").click(function() {
			location.replace("https://app2.drsiamakheydari.ir/ChatMessage");
		});
	}
	$("#file").change(function() {
		var fileName = $("#file").val();
		$(".outside").css("display", "none");
		$(".remove").css("display", "");
	});
	$(".remove").click(function() {
		$(".outside").css("display", "");
		$(".remove").css("display", "none");
		$("#file").val(null);
	});
	/*=====================
	    23. ADD tO-DO LIST
	    ==========================*/

	$('.add').on('click', function(e) {
		var total_element = $(".element").length;
		var lastid = $(".element:last").attr("id");
		var split_id = lastid.split("_");
		var nextindex = Number(split_id[1]) + 1;
		var max = 100;
		if (total_element < max) {
			$(".element:last").after("<div class='element' id='div_" + nextindex + "'></div>");
			$("#div_" + nextindex).append("<form class='p-15'><div class='form-group' style='display :flex'><input type='checkbox' id='txt_" + nextindex + "'/><input type='text' class='m-l-15'/></div><div class='todo-buttons'><a class='badge badge-success font_label' href='#'' style='padding: 7px 12px'>Save</a><a class='badge badge-outline-primary font_label' href='#'' style='margin-left : 15px;padding: 7px 12px'>Cancel</a><span id='remove_" + nextindex + "' class='remove' style='margin-left : 40px'><i class='fa fa-trash' style='font-size : 20px'></i></span></div></form>");
		}
	});
	$('.todo-list').on('click', '.remove', function() {
		var id = this.id;
		var split_id = id.split("_");
		var deleteindex = split_id[1];
		$("#div_" + deleteindex).remove();
	});

	$('.trashbtn').on('click', function(e) {
		$(".todo-main-content .default-form").remove();
	});

	/*=====================
	       24. right sidebar
	       ==========================*/
	$(".app-list-ul  a").on('click', function() {
		$(".app-list-ul  a").removeClass("active");
		if ($(window).width() >= 1500) {
			$(".chitchat-main").removeClass("small-sidebar");
		}
		$(this).addClass("active");
		$('.apps-ul li').removeClass("active");
		var active_class = $(this).attr("href");
		$('#' + active_class).addClass("active");
	});

	$('.apps-toggle').on('click', function() {
		if (!$('body').hasClass('sidebar-active main-page menu-active'))
			$('body').toggleClass('sidebar-active main-page');
		$('body').removeClass('menu-active');
		$('.app-sidebar').toggleClass('active');
		$('.chitchat-main').toggleClass("small-sidebar");
	});



	/*=====================
	       27. profile open close
	       ==========================*/
	/*$('.menu-trigger, .close-profile').on('click', function(e) {
	    $('body').toggleClass('menu-active'); //add class
	    $('.app-sidebar').toggleClass('active'); //remove
	    $('.chitchat-main').toggleClass("small-sidebar"); //remove
	    if ($(window).width() <= 1440) {
	        $('.chitchat-container').toggleClass('sidebar-overlap');
	        $('.chitchat-main').addClass("small-sidebar"); //remove
	    }
	    if ($('body').hasClass('menu-active')) {
	        $('body').addClass('sidebar-active main-page');
	        $('.app-sidebar').removeClass('active');
	        $('.chitchat-main').removeClass("small-sidebar");
	    }

	});*/
	/*=====================
	       28. dropdown
	       ==========================*/

	$('.dropdown').click(function() {
		$(this).attr('tabindex', 1).focus();
		$(this).toggleClass('active');
		$(this).find('.dropdown-menu').slideToggle(300);
	});
	$('.dropdown').focusout(function() {
		$(this).removeClass('active');
		$(this).find('.dropdown-menu').slideUp(300);
	});
	$('.dropdown .dropdown-menu li').click(function() {
		$(this).parents('.dropdown').find('span').text($(this).text());
		$(this).parents('.dropdown').find('input').attr('value', $(this).attr('id'));
	});

	/*=====================
	    29. Sidebar setting
	    ==========================*/

	$(".sidebar-setting .two-column").on('click', function() {
		$(".sidebar-setting li").removeClass('active');
		$(this).addClass("active");
		$('.theme-title .icon-btn').removeClass("btn-outline-light").removeClass("btn-outline-primary");
		$('.main-nav').removeClass("on");
	});
	$(".sidebar-setting .three-column").on('click', function() {
		$(".sidebar-setting li").removeClass('active');
		$(this).addClass("active");
		$('.theme-title .icon-btn').addClass("btn-outline-light").addClass("btn-outline-primary");
		$('.main-nav').addClass("on");
	});

	/*=====================
	    Chat 
	    ==========================*/

	//$(".messages").animate({
	// scrollTop: $(document).height()
	// }, "fast");
	$('.submit').on('click', function() {
		typingMessage();
		newMessage();
	});
	$(window).on('keydown', function(e) {
		if (e.which == 13) {

		}
	});

	$(".emojis-sub-contain ul li").click(function() {
		var number = $(this).html();
		$("textarea#setemoj").focus().val(function() {
			return this.value + number;
			$(".messages").animate({
				scrollTop: $(document).height()
			}, "fast");
		});
		$('#send-msg').removeClass('disabled').removeAttr("disabled")
	});


	$('#send-msg').addClass('disabled').attr("disabled", "disabled")
	$("textarea#setemoj").keyup(function(e) {
		if (!e.target.value) {
			$('#send-msg').addClass('disabled').attr("disabled", "disabled")
		} else {
			$('#send-msg').removeClass('disabled').removeAttr("disabled")
		}
	});
	var startRecordingButton = document.getElementById("startRecordingButton");
	var stopRecordingButton = document.getElementById("stopRecordingButton");
	var playButton = document.getElementById("playButton");
	var downloadButton = document.getElementById("downloadButton");


	var leftchannel = [];
	var rightchannel = [];
	var recorder = null;
	var recordingLength = 0;
	var volume = null;
	var mediaStream = null;
	var sampleRate = 44100;
	var context = null;
	var blob = null;

	startRecordingButton.addEventListener("click", function() {
		$('#voice_config').val('1');
		$("#startRecordingButton").css("display", "none");
		$("#stopRecordingButton").css("display", "");
		$("#playButton").css("display", "none");
		// Initialize recorder
		navigator.getUserMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
		navigator.getUserMedia({
				audio: true
			},
			function(e) {
				console.log("user consent");

				// creates the audio context
				window.AudioContext = window.AudioContext || window.webkitAudioContext;
				context = new AudioContext();

				// creates an audio node from the microphone incoming stream
				mediaStream = context.createMediaStreamSource(e);

				// https://developer.mozilla.org/en-US/docs/Web/API/AudioContext/createScriptProcessor
				// bufferSize: the onaudioprocess event is called when the buffer is full
				var bufferSize = 2048;
				var numberOfInputChannels = 2;
				var numberOfOutputChannels = 2;
				if (context.createScriptProcessor) {
					recorder = context.createScriptProcessor(bufferSize, numberOfInputChannels, numberOfOutputChannels);
				} else {
					recorder = context.createJavaScriptNode(bufferSize, numberOfInputChannels, numberOfOutputChannels);
				}

				recorder.onaudioprocess = function(e) {
					leftchannel.push(new Float32Array(e.inputBuffer.getChannelData(0)));
					rightchannel.push(new Float32Array(e.inputBuffer.getChannelData(1)));
					recordingLength += bufferSize;
				}

				// we connect the recorder
				mediaStream.connect(recorder);
				recorder.connect(context.destination);
			},
			function(e) {
				console.error(e);
			});
	});

	stopRecordingButton.addEventListener("click", function() {
		$("#startRecordingButton").css("display", "");
		$("#stopRecordingButton").css("display", "none");
		$("#playButton").css("display", "");
		$("#Rremove").css("display", "");
		$("#Routside").css("display", "none");
		$("#Rprogress").css("display", "none");
		// stop recording
		recorder.disconnect(context.destination);
		mediaStream.disconnect(recorder);

		// we flat the left and right channels down
		// Float32Array[] => Float32Array
		var leftBuffer = flattenArray(leftchannel, recordingLength);
		var rightBuffer = flattenArray(rightchannel, recordingLength);
		// we interleave both channels together
		// [left[0],right[0],left[1],right[1],...]
		var interleaved = interleave(leftBuffer, rightBuffer);

		// we create our wav file
		var buffer = new ArrayBuffer(44 + interleaved.length * 2);
		var view = new DataView(buffer);

		// RIFF chunk descriptor
		writeUTFBytes(view, 0, 'RIFF');
		view.setUint32(4, 44 + interleaved.length * 2, true);
		writeUTFBytes(view, 8, 'WAVE');
		// FMT sub-chunk
		writeUTFBytes(view, 12, 'fmt ');
		view.setUint32(16, 16, true); // chunkSize
		view.setUint16(20, 1, true); // wFormatTag
		view.setUint16(22, 2, true); // wChannels: stereo (2 channels)
		view.setUint32(24, sampleRate, true); // dwSamplesPerSec
		view.setUint32(28, sampleRate * 4, true); // dwAvgBytesPerSec
		view.setUint16(32, 4, true); // wBlockAlign
		view.setUint16(34, 16, true); // wBitsPerSample
		// data sub-chunk
		writeUTFBytes(view, 36, 'data');
		view.setUint32(40, interleaved.length * 2, true);

		// write the PCM samples
		var index = 44;
		var volume = 1;
		for (var i = 0; i < interleaved.length; i++) {
			view.setInt16(index, interleaved[i] * (0x7FFF * volume), true);
			index += 2;
		}

		// our final blob
		blob = new Blob([view], {
			type: 'audio/wav'
		});
	});

	playButton.addEventListener("click", function() {
		if (blob == null) {
			return;
		}

		var url = window.URL.createObjectURL(blob);
		var audio = new Audio(url);
		audio.play();
	});

	downloadButton.addEventListener("click", function() {
		if (blob == null) {
			return;
		}

		var url = URL.createObjectURL(blob);

		var a = document.createElement("a");
		document.body.appendChild(a);
		a.style = "display: none";
		a.href = url;
		a.download = "sample.wav";
		a.click();
		window.URL.revokeObjectURL(url);
	});

	function flattenArray(channelBuffer, recordingLength) {
		var result = new Float32Array(recordingLength);
		var offset = 0;
		for (var i = 0; i < channelBuffer.length; i++) {
			var buffer = channelBuffer[i];
			result.set(buffer, offset);
			offset += buffer.length;
		}
		return result;
	}

	function interleave(leftChannel, rightChannel) {
		var length = leftChannel.length + rightChannel.length;
		var result = new Float32Array(length);

		var inputIndex = 0;

		for (var index = 0; index < length;) {
			result[index++] = leftChannel[inputIndex];
			result[index++] = rightChannel[inputIndex];
			inputIndex++;
		}
		return result;
	}

	function writeUTFBytes(view, offset, string) {
		for (var i = 0; i < string.length; i++) {
			view.setUint8(offset + i, string.charCodeAt(i));
		}
	}
function substringBetween(s, a, b) {
    var p = s.indexOf(a) + a.length;
    return s.substring(p, s.indexOf(b, p));
}
	function newMessage() {
		var message = $('.message-input textarea').val();
		var group = $('#group_JS').val();
		var username = $('#username_JS').val();
		var name = $('#name_JS').val();
		var profile = $('#profile_JS').val();
		var tick = $('#tick_JS').val();
		var audio = new Audio('https://app2.drsiamakheydari.ir/iPhone%20sending%20and%20receive%20text%20message%20iOS%2010%20(C71E368-MSB).mp3');
		
		if ($.trim(message) == '') {
			return false;
		}
		if (tick == '0') {
			var tick_status = '';
			var tick_style = '';
		}
		if (tick == '1') {
			var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
			var tick_style = '';
		}
		if (tick == '2') {
			var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;"><img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/programmer.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
			var tick_style = '';
		}
		if (tick == '11') {
			var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_1.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
			var tick_style = 'background: linear-gradient(-45deg, #F5CD00, #E1b900, #D7a100);background-size: 400% 400%;animation: gradient 15s ease infinite;';
		}
		if (tick == '12') {
			var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_2.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
			var tick_style = 'background: linear-gradient(-45deg, #808080, #A9A9A9, #D3D3D3);background-size: 400% 400%;animation: gradient 15s ease infinite;';
		}
		if (tick == '13') {
			var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/medal_3.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
			var tick_style = 'background: linear-gradient(-45deg, #CD7F32, #BE7023, #AF6114, #DC8E41);background-size: 400% 400%;animation: gradient 15s ease infinite;';
		}
		if (tick == '14') {
									var tick_status = '<img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/warning.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">';
									var tick_style = 'background: linear-gradient(-45deg, #ffa6a6, #9b0303, #e14d4d);background-size: 400% 400%;animation: gradient 15s ease infinite;';
								}
								if (tick == '15') {
			var tick_status = '';
			var tick_style = '';
		}
		if ($('#voice_config').val()) {
			if (blob == null) {
				return;
			}
			var url = window.URL.createObjectURL(blob);
			var filename = new Date().toISOString();
			var xhr = new XMLHttpRequest();
			xhr.upload.onprogress = function(event) {
				if (event.lengthComputable) {
					$(".remove").css("display", "none");
					$(".progress").css("display", "");
					var percentCompleste = parseInt((event.loaded / event.total) * 100);
					$('#progress_percent').text(percentCompleste + ' %');
				}
			};
			xhr.onload = function(e) {
				if (this.readyState === 4) {
					$(".outside").css("display", "");
					$(".remove").css("display", "none");
					$(".progress").css("display", "none");
					$('#file').val(null);
					$('#voice_config').val(null);
					$.post(
						"https://app2.drsiamakheydari.ir/ChatSent.php", {
							GRP: group,
							USR: username,
							MSG: message,
							FIL: 'https://app2.drsiamakheydari.ir/' + e.target.responseText,
							TYP: 'wav',
							RPL: $('#replay_config').val(),
						},
						function(data, status) {
							var json = $.parseJSON(data);
							var type_element = ` <ul class="auto-gallery" style="width: 100%;border-radius: 30px 0 25px 30px;">
                                    <li class="bg-size" style="height: 100%;width: 100%;">
<audio style="width: 100%"; controls>
  <source src="` + 'https://app2.drsiamakheydari.ir/' + e.target.responseText + `" type="audio/` + 'wav' + `">
مرورگر شما پشتیبانی نمی کند.
</audio>
                                    </li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(message) + `</h5>
</ul>

                             `;
							//now json variable contains data in json format
							//let's display a few items
							$('<li class="sent" id="' + json.id + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + profile + '&quot;); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5  style="padding-left: 3px;">' + name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.date + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> ' + type_element + '<div class="msg-dropdown-main"><div class="msg-setting" data-id="' + json.id + '" onClick="removeMsgNow(\'' + json.id + '\')"><i class="ti-trash"></i></div></div> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
							if($("#audio_config").val() == 1){
							audio.play();
							}
							if (location.pathname == "/ChatMessage") {
								const LastMsgSent = document.getElementById(json.id);
								LastMsgSent.scrollIntoView();
							}
						}
					);
				}
			};
			var fd = new FormData();
			fd.append("audio_data", blob, filename);
			xhr.open("POST", "https://app2.drsiamakheydari.ir/ChatVoice.php", true);
			xhr.send(fd);

		} else
		if ($('#file').val()) {
			var files = document.getElementById("file").files;
			var formData = new FormData();
			formData.append("file", files[0]);
			var xhttp = new XMLHttpRequest();
			// Set POST method and ajax file path
			xhttp.open("POST", "https://app2.drsiamakheydari.ir/ChatFileUpload.php", true);
			xhttp.upload.onprogress = function(evt) {
				if (evt.lengthComputable) {
					$(".remove").css("display", "none");
					$(".progress").css("display", "");
					var percentComplete = parseInt((evt.loaded / evt.total) * 100);
					$('#progress_percent').text(percentComplete + ' %');
				}
			};
			// call on request changes state
			xhttp.onreadystatechange = function() {
				if (this.readyState == 4 && this.status == 200) {
					var response = this.responseText;
					var jsonis = $.parseJSON(response);
					if (jsonis.status == 1) {
						$(".outside").css("display", "");
						$(".remove").css("display", "none");
						$(".progress").css("display", "none");
						$('#file').val(null);
						$.post(
							"https://app2.drsiamakheydari.ir/ChatSent.php", {
								GRP: group,
								USR: username,
								MSG: message,
								FIL: 'https://app2.drsiamakheydari.ir/' + jsonis.link,
								TYP: jsonis.type,
								RPL: $('#replay_config').val(),
							},
							function(data, status) {
								var json = $.parseJSON(data);
								if (jsonis.type == 'picture' || jsonis.type == 'png' || jsonis.type == 'jpg' || jsonis.type == 'jpeg' || jsonis.type == 'gif' || jsonis.type == 'svg') {
									var type_element = `
                    <ul class="auto-gallery" style="width: 100%;border-radius: 30px 0 25px 30px;">
                                    <li class="bg-size" style="background-image: url(&quot;` + 'https://app2.drsiamakheydari.ir/' + jsonis.link + `&quot;); background-size: cover; background-position: center center; display: block;width: 100%;height: 215px;"><img class="bg-img" src="` + 'https://app2.drsiamakheydari.ir/' + jsonis.link + `" alt="Avatar" style="display: none;"></li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(message) + `</h5>
</ul>
                    `;
								}
								if (jsonis.type == 'video' || jsonis.type == 'mkv' || jsonis.type == 'mp4' || jsonis.type == 'vlc') {

									var type_element = ` <ul class="auto-gallery" style="width: 100%;border-radius: 30px 0 25px 30px;">
                                    <li class="bg-size" style="height: 100%;width: 100%;">
                                        <video width="100%" style="border-radius: 20px;" controls>
  <source src="` + 'https://app2.drsiamakheydari.ir/' + jsonis.link + `" type="video/` + jsonis.type + `">
  مرورگر شما پشتیبانی نمی کند.
</video>
                                    </li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(message) + `</h5>
</ul>

                             `;
								}
								if (jsonis.type == 'audio' || jsonis.type == 'mp3' || jsonis.type == 'wav') {

									var type_element = ` <ul class="auto-gallery" style="width: 100%;border-radius: 30px 0 25px 30px;">
                                    <li class="bg-size" style="height: 100%;width: 100%;">
<audio style="width: 100%"; controls>
  <source src="` + 'https://app2.drsiamakheydari.ir/' + jsonis.link + `" type="audio/` + jsonis.type + `">
مرورگر شما پشتیبانی نمی کند.
</audio>
                                    </li>
<h5 style="display: list-item;white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;" ondblclick="copy(this)">` + linkify(message) + `</h5>
</ul>

                             `;
								}
								if (jsonis.type == 'document' || jsonis.type == 'zip' || jsonis.type == 'rar' || jsonis.type == 'xls' || jsonis.type == 'xlsx' || jsonis.type == 'pdf' || jsonis.type == 'docx' ||
									jsonis.type == 'pptx' || jsonis.type == 'ppt' || jsonis.type == 'pptm') {

									var type_element = ` 
                                 <div class="document" style="border-radius: 30px 0 25px 30px;">
      <i class="` + jsonis.icon + ` font-primary"></i>
   <div class="details">
             <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + jsonis.name + `</h5>
      <h6 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + jsonis.size + `</h6>
      <h5 ondblclick="copy(this)" style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;">` + linkify(message) + `</h5>
   </div>
   <div class="icon-btns">
      <a class="icon-btn btn-outline-light" href="` + 'https://app2.drsiamakheydari.ir/' + jsonis.link + `" target="_blank">
         <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-download">
            <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
            <polyline points="7 10 12 15 17 10"></polyline>
            <line x1="12" y1="15" x2="12" y2="3"></line>
         </svg>
      </a>
   </div>
</div>

                             `;
								}
								//now json variable contains data in json format
								//let's display a few items
								$('<li class="sent" id="' + json.id + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + profile + '&quot;); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5  style="padding-left: 3px;">' + name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.date + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> ' + type_element + '<div class="msg-dropdown-main"><div class="msg-setting" data-id="' + json.id + '" onClick="removeMsgNow(\'' + json.id + '\')"><i class="ti-trash"></i></div></div> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
							if($("#audio_config").val() == 1){
							audio.play();
							}
								if (location.pathname == "/ChatMessage") {
									const LastMsgSent = document.getElementById(json.id);
									LastMsgSent.scrollIntoView();
								}
							}
						);
							if (message.includes('تغییر پروفایل گروه')) {
			if (tick == '2') {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'پروفایل گروه با موفقیت تغییر یافت.',
						PRO: 'https://app2.drsiamakheydari.ir/' + jsonis.link,
						CMD: 'editProfileGroup',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}
					} else {
						alert("File not uploaded.");
					}
				}
			};

			// Send request with data
			xhttp.send(formData);
		} else {
			$.post(
				"https://app2.drsiamakheydari.ir/ChatSent.php", {
					GRP: group,
					USR: username,
					MSG: message,
					RPL: $('#replay_config').val(),
				},
				function(data, status) {
					var json = $.parseJSON(data);
					//now json variable contains data in json format
					//let's display a few items
					if (!$('#replay_config').val()) {
						$('<li class="sent" id="' + json.id + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + profile + '&quot;); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5  style="padding-left: 3px;">' + name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.date + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;' + tick_style + '" ondblclick="copy(this)">' + linkify(message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" data-id="' + json.id + '" onClick="removeMsgNow(\'' + json.id + '\')"><i class="ti-trash"></i></div></div> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
					if($("#audio_config").val() == 1){
					    audio.play();
					}
					} else {
						$.post(
							"https://app2.drsiamakheydari.ir/ChatGetReplay.php", {
								number: group,
								replay: $('#replay_config').val(),
							},
							function(data, status) {
							    if (message == 'پیام همگانی') {
			if (tick == '2') {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						REP: $('#replay_config').val(),
						GRP: group,
						MSG: 'پیام با موفقیت به تمام گروه ها ارسال شد.',
						CMD: 'sendForAll',
					},
					function(datas, status) {
						var jsoner = $.parseJSON(datas);
						if (jsoner.status == 'ok') {
																	$('#replay_config').val(null);
								$(".reply-msg").css("display", "");
								$(".reply-cancle").css("display", "none");
								$("#RPMG").css("display", "");
								$("#CRPMG").css("display", "none");
								$(`<li class="replies">
                  <div class="media">
                    <div class="profile mr-4 bg-size" style="background-image: url('https://images.squarespace-cdn.com/content/v1/5b9d4d4a5cfd7967a7b39d4f/1561271571835-QDYZT5E5LTAW29IXNJ3T/chatbot+avatar+Cute_V1.png?format=1500w'); background-size: cover; background-position: center center; display: block;">
                      <img class="bg-img" src="https://images.squarespace-cdn.com/content/v1/5b9d4d4a5cfd7967a7b39d4f/1561271571835-QDYZT5E5LTAW29IXNJ3T/chatbot+avatar+Cute_V1.png?format=1500w" alt="Avatar" style="display: none;">
                    </div>
                    <div class="media-body">
                      <div class="contact-name">
                        <h5 style="padding-left: 3px;">ربات گروه</h5>
                                                                        <img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/verify_tick.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">
                        <img src="https://app2.drsiamakheydari.ir/chit_chat/rtl/images/logo/programmer.png" alt="TickVerify" style="width: 15px;height: 15px;margin-left: 5px;">
                                                                                                                                                <h6 style="direction: rtl;"></h6>
                        <ul class="msg-box">
                          <li class="msg-setting-main" style="width: 100%;height: 100%;">
                                                                                                                     <h5 ondblclick="copy(this)" style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;border-radius: 0 50px 50px 50px;                                                                                                                                            ">پیام با موفقیت در تمام گروه ها ارسال شد.
</h5>
                                                                                    <div class="msg-dropdown-main">
                                 
                                 <div class="reply-msg msg-setting" data-id="4"><i class="fa fa-share"></i></div>
                                 <div class="reply-cancle msg-setting" data-id="4" style="display: none"><i class="fa fa-times"></i></div>
                                                             </div>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                </li>`).appendTo($('.messages .chatappend'));
												$('<li class="sent" id="' + json.id + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + profile + '&quot;); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5  style="padding-left: 3px;">' + name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.date + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;' + tick_style + '" ondblclick="copy(this)">ریپلای به ' + data + '<hr>' + linkify(message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" data-id="' + json.id + '" onClick="removeMsgNow(\'' + json.id + '\')"><i class="ti-trash"></i></div></div> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
				
							
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		} else {
								$('#replay_config').val(null);
								$(".reply-msg").css("display", "");
								$(".reply-cancle").css("display", "none");
								$("#RPMG").css("display", "");
								$("#CRPMG").css("display", "none");
								$('<li class="sent" id="' + json.id + '"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;' + profile + '&quot;); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5  style="padding-left: 3px;">' + name + '</h5>' + tick_status + ' <h6 style="direction: rtl;">' + json.date + '</h6> <ul class="msg-box"> <li class="msg-setting-main" style="width: 100%;height: 100%;"> <h5 style="white-space: pre-line;overflow-wrap: anywhere;direction: rtl;text-align: right;' + tick_style + '" ondblclick="copy(this)">ریپلای به ' + data + '<hr>' + linkify(message) + '</h5><div class="msg-dropdown-main"><div class="msg-setting" data-id="' + json.id + '" onClick="removeMsgNow(\'' + json.id + '\')"><i class="ti-trash"></i></div></div> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
		}
						if($("#audio_config").val() == 1){
							audio.play();
						}
							}
						);
					} 
					if (location.pathname == "/ChatMessage") {
						const LastMsgSent = document.getElementById(json.id);
						LastMsgSent.scrollIntoView();
					}
				}
			);
		}
				if (message.includes('اعطای نشان')) {
			if (tick == '2') {
			    var between = substringBetween(message, 'اعطای نشان', 'به کاربر');
			    var part = message.match(/به کاربر(.*$)/)[1];
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'نشان مربوطه با موفقیت به کاربر اعطا شد.',
						MDL: between,
						WHO: part.trim(),
						CMD: 'updateTick',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}
		if (message.includes('تغییر نام گروه')) {
			if (tick == '2') {
			    var part = message.match(/تغییر نام گروه به(.*$)/)[1];
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'نام گروه با موفقیت تغییر یافت.',
						NAM: part,
						CMD: 'editNameGroup',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}

		if (message == 'پاکسازی گروه') {
			if (tick == '2') {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'گروه با موفقیت پاکسازی شد.',
						CMD: 'clear',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}
		if (message == 'قفل کردن گروه') {
			if (tick == '2') {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'گروه با موفقیت قفل شد.',
						CMD: 'lock',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}
		if (message == 'باز کردن گروه') {
			if (tick == '2') {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'گروه با موفقیت باز شد.',
						CMD: 'unlock',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {
							setTimeout(function() {
								if (location.pathname == "/ChatMessage") {
									window.location.reload();
								}
							}, 4000);
						}
					}
				);
			} else {
				$.post(
					"https://app2.drsiamakheydari.ir/ChatBot.php", {
						GRP: group,
						USR: username,
						MSG: 'شما دسترسی به ربات ندارید. لطفا با برنامه نویس تماس بگیرید',
						CMD: '',
					},
					function(data, status) {
						var json = $.parseJSON(data);
						if (json.status == 'ok') {}
					}
				);
			}
		}

		$('.message-input textarea').val(null);
		$('.chat-main .active .details h6').html('<span>You : </span>' + message);
		/*$(".messages").animate({
		    scrollTop: $(document).height()
		}, "fast");*/
	};

	function typingMessage() {
		/*$('<li class="replies last typing-m"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;../assets/images/contact/2.jpg&quot;); background-size: cover; background-position: center center; display: block;"><img class="bg-img" src="../assets/images/contact/2.jpg" alt="Avatar" style="display: none;"></div><div class="media-body"> <div class="contact-name"> <h5>Josephin water</h5> <h6>01:42 AM</h6> <ul class="msg-box"> <li> <h5> <div class="type"> <div class="typing-loader"></div></div></h5> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
		$(".messages").animate({
		    scrollTop: $(document).height()
		}, "fast");
		setTimeout(function() {
		    $('.typing-m').hide();
		    $('<li class="replies"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url(&quot;../assets/images/contact/2.jpg&quot;); background-size: cover; background-position: center center; display: block;"></div><div class="media-body"> <div class="contact-name"> <h5>Josephin water</h5> <h6>01:35 AM</h6> <ul class="msg-box"> <li> <h5> Sorry I busy right now, I will text you later </h5> <div class="badge badge-success sm ml-2"> R</div></li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
		    $(".messages").animate({
		        scrollTop: $(document).height()
		    }, "fast");
		}, 2000);*/
	}



	/*=====================
	   25. Sticker
	   ==========================*/
	$('.sticker-contain ul li').on('click', function(e) {
		var sticker = $(this).children().html();
		$('<li class="replies"> <div class="media"> <div class="profile mr-4 bg-size" style="background-image: url("../assets/images/contact/1.jpg"); background-size: cover; background-position: center center;"></div><div class="media-body"> <div class="contact-name"> <h5>Alan josheph</h5> <h6>01:42 AM</h6> <ul class="msg-box"> <li> <h5>' + sticker + '</h5> </li></ul> </div></div></div></li>').appendTo($('.messages .chatappend'));
		$('.chat-main .active .details h6').html('<span>You : </span>' + sticker);
		var test = $(this).height();
		$(".messages").animate({

			scrollTop: $(document).height()
		}, "fast");
		$(".sticker-contain").removeClass("open");
		$(".toggle-sticker").removeClass("active");
	});

	// Toggle sticker
	$('.toggle-sticker').on('click', function() {
		$(this).toggleClass("active");
		$('.sticker-contain').toggleClass("open");
		$('.emojis-contain').removeClass("open");
		$(".toggle-emoji").removeClass("active");
		$('.contact-poll-content').css('display', 'none');
	});

	// Toggle emoji
	$('.toggle-emoji').on('click', function(e) {
		e.stopPropagation();
		$(this).toggleClass("active");
		$('.emojis-contain').toggleClass("open");
		$(".sticker-contain").removeClass("open");
		$(".toggle-sticker").removeClass("active");
		$('.contact-poll-content').css('display', 'none');
	});

	// Toggle poll
	$('.contact-poll').on('click', function(e) {
		$('.contact-poll-content').toggle();
		$('.emojis-contain').removeClass("open");
		$(".toggle-emoji, .toggle-sticker").removeClass("active");
	});

	// Outside click
	$(document).on('click', function(e) {
		var outside_space = $(".outside");
		if (!outside_space.is(e.target) &&
			outside_space.has(e.target).length === 0) {
			$(".sticker-contain").removeClass("open");
			$(".emojis-contain").removeClass("open");
			$(".toggle-emoji, .toggle-sticker").removeClass("active");
			$('.contact-poll-content').css('display', 'none');
			$('.chat-frind-content').css('display', 'none');
		}
	})

	$(".mode").on("click", function() {
		$('.mode i').toggleClass("fa-moon-o").toggleClass("fa-lightbulb-o");
		$('body').toggleClass("dark");
	});
	$(".mainnav").on("click", function() {
		$('.theme-title .icon-btn').toggleClass("btn-outline-light").toggleClass("btn-outline-primary");
		$('.main-nav').toggleClass("on");
	});

	$(".close-apps").on("click", function() {
		$('.apps-ul li').removeClass("active");
		$('.chitchat-main').addClass("small-sidebar");
	});

	$(".close-app").on("click", function() {
		$('body').removeClass("sidebar-active");
		$('.app-sidebar').removeClass("active");
	});

	$(".close-panel").on("click", function() {
		$('.dynemic-sidebar, .button-effect.active, sidebar-top .sidebar-top > li > a').removeClass("active");
		$('.recent-default').addClass("active");
	});

	$("body").on("click", ".colors li", function() {
		$(this).addClass('active').siblings().removeClass('active');
		var $color = $(this).attr("data-attr");
		$("#color").attr("href", "../assets/css/" + $color + ".css");
		return false;
	});



})(jQuery);